/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcastlistener.h"

namespace ttv {
namespace broadcast {
class BandwidthReport;
}
}  // namespace ttv

/**
 * Aggregates bandwidth statistics into CSV data.
 */
class ttv::broadcast::BandwidthReport : public IBandwidthStatListener {
 public:
  virtual void ReceivedBandwidthStat(const BandwidthStat& stat) override;
  std::string DumpCsvData();
  void Clear();

 private:
  std::deque<BandwidthStat> mStats;
};
