/********************************************************************************************
 * Twitch Broadcasting SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 *********************************************************************************************/

#pragma once

#include "twitchsdk/core/types/errortypes.h"

/**
 * The unique module identifier for broadcast.
 */
const uint32_t TTV_MODULE_ID_TWITCH_BROADCAST = 4;

#define TTV_BROADCAST_ERROR_IDS                                                                                                                                                                 \
  /* Errors */                                                                                                                                                                                  \
  BEGIN_ERROR_IDS(TTV_EC_BROADCAST_BEGIN_ERRORS)                                                                                                                                                \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_NOMOREDATA)                                                                                                                                                 \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_ALIGN16_REQUIRED)                                                                                                                                           \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_UNSUPPORTED_INPUT_FORMAT)                                                                                                                                   \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_UNSUPPORTED_OUTPUT_FORMAT)                                                                                                                                  \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_RESOLUTION)                                                                                                                                         \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_FPS)                                                                                                                                                \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_BITRATE)                                                                                                                                            \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_AUDIO_LAYER)                                                                                                                                        \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_VIDEO_CAPTURER)                                                                                                                                     \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_ENCODE_FAILED)                                                                                                                                              \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_BUFFER_ALLOCATION_FAILED)                                                                                                                                   \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FAILED_TO_INIT_SPEAKER_CAPTURE)                                                                                                                             \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FRAMES_QUEUEING)                                                                                                                                            \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FRAME_QUEUE_FULL)                                                                                                                                           \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_NO_STREAM_KEY)                                                                                                                                              \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_VIDEOFRAME)                                                                                                                                         \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_NO_SPSPPS)                                                                                                                                                  \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_NO_D3D_SUPPORT)                                                                                                                                             \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_NO_INGEST_SERVER_AVAILABLE)                                                                                                                                 \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_INGEST_SERVER)                                                                                                                                      \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_ENCODER)                                                                                                                                            \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_VIDEO_ENCODER_INIT_FAILED)                                                                                                                                  \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_AUDIO_ENCODER_INIT_FAILED)                                                                                                                                  \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_VIDEO_FRAME_SUBMISSION_FAILED)                                                                                                                              \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_AUDIO_DEVICE_INIT_FAILED)                                                                                                                                   \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_AUDIO_BUFFER_TOO_BIG)                                                                                                                                       \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_AUDIO_PASSTHROUGH_NOT_ENABLED)                                                                                                                              \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_SAMPLERATE)                                                                                                                                         \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_X264_INVALID_PRESET)                                                                                                                                        \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_X264_INVALID_PROFILE)                                                                                                                                       \
  /*****/                                                                                                                                                                                       \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FLV_UNABLE_TO_OPEN_FILE)                                                                                                                                    \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FLV_FILE_NOT_OPEN)                                                                                                                                          \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_RATE)                                                                                                                                 \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_IDC)                                                                                                                                  \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_FLV_UNSUPPORTED_AUDIO_CODEC)                                                                                                                                \
  /*****/                                                                                                                                                                                       \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_RTMP_REJECTED)                                                                                                                                              \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_RTMP_WRONG_PROTOCOL_IN_URL)                                                                                                                                 \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_RTMP_UNABLE_TO_SEND_DATA)                                                                                                                                   \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_RTMP_INVALID_FLV_PACKET)                                                                                                                                    \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_RTMP_TIMEOUT)                                                                                                                                               \
  /* Mac audio capture */                                                                                                                                                                       \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_MAC_INPUT_Q_SETUP_FAILED)                                                                                                                                   \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_MAC_INPUT_Q_BUFFER_SETUP_FAILED)                                                                                                                            \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_MAC_INPUT_Q_START_FAILED)                                                                                                                                   \
  /*****************************/                                                                                                                                                               \
  /* Intel encoder */                                                                                                                                                                           \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INTEL_FAILED_SESSION_INIT)                                                                                                                                  \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INTEL_FAILED_VPP_INIT)                                                                                                                                      \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INTEL_FAILED_ENCODER_INIT)                                                                                                                                  \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INTEL_FAILED_SURFACE_ALLOCATION)                                                                                                                            \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INTEL_FAILED_TASKPOLL_INIT)                                                                                                                                 \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INTEL_NO_FREE_TASK)                                                                                                                                         \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INTEL_NO_FREE_SURFACE)                                                                                                                                      \
  /*****************************/                                                                                                                                                               \
  /*****************************/                                                                                                                                                               \
  /* lame mp3 encoder */                                                                                                                                                                        \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_LAMEMP3_FAILED_INIT)                                                                                                                                        \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_LAMEMP3_FAILED_SHUTDOWN)                                                                                                                                    \
  /*****************************/                                                                                                                                                               \
  /* Apple aac encoder */                                                                                                                                                                       \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_APPLEAAC_FAILED_INIT)                                                                                                                                       \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_APPLEAAC_FAILED_ENCODING)                                                                                                                                   \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_APPLEAAC_FAILED_SHUTDOWN)                                                                                                                                   \
  /*****************************/                                                                                                                                                               \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_INVALID_SUBMISSION_METHOD)                                                                                                                                  \
  /**/                                                                                                                                                                                          \
  USE_TTV_ERROR_ID(                                                                                                                                                                             \
    TTV_EC_BROADCAST_STREAM_ALREADY_STARTED) /*!< The requested operation can't be serviced because the broadcast has already been started. */                                                  \
  USE_TTV_ERROR_ID(                                                                                                                                                                             \
    TTV_EC_BROADCAST_STREAM_NOT_STARTED) /*!< The requested operation can't be serviced because the broadcast not been started.  */                                                             \
  USE_TTV_ERROR_ID(                                                                                                                                                                             \
    TTV_EC_BROADCAST_FRAME_QUEUE_TOO_LONG) /*!< The network is backing up because video settings are too high for the internet connection.  Stop the stream and restart with lower settings. */ \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_GRAPHICS_API_ERROR) /*!< Error in a native graphics API call. */                                                                                            \
  USE_TTV_ERROR_ID(                                                                                                                                                                             \
    TTV_EC_BROADCAST_METADATA_CACHE_FULL) /*!< The local cache of meta data is full and the latest request was not competed. Wait some time until it flushes. */                                \
  USE_TTV_ERROR_ID(                                                                                                                                                                             \
    TTV_EC_BROADCAST_SOUNDFLOWER_NOT_INSTALLED) /*!< Mac requires SoundFlower to be installed to capture system audio. */                                                                       \
  USE_TTV_ERROR_ID(TTV_EC_BROADCAST_NO_ENCODER_PLUGIN) /*!< Trying to use an encoder plugin but it was never set */                                                                             \
  END_ERROR_IDS(TTV_EC_BROADCAST_END_ERRORS)

#define USE_TTV_ERROR_ID(ec) ec,
#define USE_TTV_SUCCESS_ID(ec) ec = 0,
#define BEGIN_ERROR_IDS(ec) ec = CONSTRUCT_ERROR_ID_VALUE(TTV_MODULE_ID_TWITCH_BROADCAST, 1),
#define END_ERROR_IDS(ec) ec

/**
 * TTV_BroadcastErrorId - The error codes defined in broadcast.
 */
enum TTV_BroadcastErrorId { TTV_BROADCAST_ERROR_IDS };

#undef BEGIN_ERROR_IDS
#undef END_ERROR_IDS
#undef USE_TTV_SUCCESS_ID
#undef USE_TTV_ERROR_ID

namespace ttv {
namespace broadcast {
/**
 * The error code string lookup for broadcast.  This is not normally used directly by clients.  Use ttv::ErrorToString()
 * instead.
 */
const char* BroadcastErrorToString(TTV_ErrorCode ec);

void GetBroadcastErrorCodeValues(std::vector<EnumValue>& result);
}  // namespace broadcast
}  // namespace ttv
