/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"

#include <memory>

namespace ttv {
namespace broadcast {
class FrameCapturer;
class BroadcastAPI;
}  // namespace broadcast
}  // namespace ttv

//
///**
// * The base class for automatic frame capturers.
// */
// class ttv::broadcast::FrameCapturer
//{
// public:
//  FrameCapturer();
//  virtual ~FrameCapturer();
//
//  virtual TTV_ErrorCode SetBroadcastAPI(std::shared_ptr<BroadcastAPI> api);
//
//  virtual TTV_ErrorCode Start(const TTV_VideoParams* videoParams, const TTV_AudioParams* audioParams, const
//  TTV_IngestServer* ingestServer, uint32_t flags); virtual TTV_ErrorCode Stop(); virtual TTV_ErrorCode
//  PauseFrameSubmission(); virtual TTV_ErrorCode ResumeFrameSubmission(); virtual TTV_ErrorCode SubmitTexture(void* p,
//  int width, int height) = 0;
//
//  virtual void Shutdown();
//  virtual void PreDeviceReset();
//  virtual void PostDeviceReset();
//  virtual bool RequiresVerticalFlip();
//
//  bool GetIsStarted() const { return mStarted; }
//
// protected:
//  static void BufferUnlockCallback(const uint8_t* buffer, void* userData);
//
//  virtual bool ShouldCreateFrameBuffers() const;
//  virtual void HandleBufferUnlock(const uint8_t* buffer);
//  virtual void CleanupObjects();
//  virtual TTV_ErrorCode SubmitVideoFrame(const uint8_t* frameBuffer, TTV_BufferUnlockCallback callback, void*
//  userData);
//
//  using BufferList = std::vector<uint8_t*>;
//
//  BufferList mAllFrameBuffers;
//  BufferList mFreeFrameBuffers;
//  TTV_VideoParams mVideoParams;
//  bool mStarted;
//  std::shared_ptr<BroadcastAPI> mBroadcastAPI;
//
//  static const size_t kNumBuffers = 3;
//};
