/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/variant.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace broadcast
    {
        namespace graphql
        {
            namespace json
            {
                struct GetStreamKeyStreamKey;
                struct GetStreamKeyStreamKeyError;
                struct GetStreamKeyStreamKeyResult;
                struct GetStreamKeyVideoStreamSettings;
                struct GetStreamKeyChannel;
                struct GetStreamKeyPayloadType;
                struct GetStreamKeyInputParams;
                struct GetStreamKeyStreamKeyResultStreamKeySchemaSelector;
            }

            struct GetStreamKeyQueryInfo
            {
                struct StreamKey
                {
                    std::string value;
                };

                struct StreamKeyError
                {
                    std::string code;
                    std::vector<std::string> links;
                    std::string message;
                };

                struct StreamKeyResult
                {
                    std::string __typename;
                    ttv::Variant<StreamKey, StreamKeyError> streamKeyVariant;
                };

                struct VideoStreamSettings
                {
                    StreamKeyResult streamKey;
                };

                struct Channel
                {
                    ttv::Optional<VideoStreamSettings> videoStreamSettings;
                };

                struct PayloadType
                {
                    std::string id;
                    ttv::Optional<std::string> profileURL;
                    ttv::Optional<std::string> displayName;
                    ttv::Optional<std::string> login;
                    ttv::Optional<Channel> channel;
                };

                struct InputParams
                {
                    std::string authToken;
                    std::string userId;
                };

                static constexpr const char* kTaskName = "GraphQLTask: GetStreamKey";
                static constexpr auto kQuery = R"(
                    # gen_full
                    query GetStreamKey($userId: ID!)
                    {
                        user(id:$userId)
                        {
                            id
                            profileURL
                            displayName
                            login
                            channel {
                                videoStreamSettings {
                                    streamKey {
                                        __typename
                                        ... on StreamKey {
                                            value
                                        }
                                        ... on StreamKeyError {
                                            code
                                            links
                                            message
                                        }
                                    }
                                }
                            }
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::broadcast::graphql::json::GetStreamKeyStreamKey
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& streamKey)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("value", streamKey.value)
        );
    }
};


struct ttv::broadcast::graphql::json::GetStreamKeyStreamKeyError
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& streamKeyError)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("code", streamKeyError.code),
            make_field<RequiredField>("links", streamKeyError.links),
            make_field<RequiredField>("message", streamKeyError.message)
        );
    }
};


struct ttv::broadcast::graphql::json::GetStreamKeyStreamKeyResult
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& streamKeyResult)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("__typename", streamKeyResult.__typename),
            make_variant_selector<RequiredField>(streamKeyResult.streamKeyVariant)
        );
    }
};


struct ttv::broadcast::graphql::json::GetStreamKeyVideoStreamSettings
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& videoStreamSettings)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("streamKey", videoStreamSettings.streamKey)
        );
    }
};


struct ttv::broadcast::graphql::json::GetStreamKeyChannel
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& channel)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("videoStreamSettings", channel.videoStreamSettings)
        );
    }
};


struct ttv::broadcast::graphql::json::GetStreamKeyPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>(MakeKeyPath("user", "id"), payloadType.id),
            make_field<OptionalField>(MakeKeyPath("user", "profileURL"), payloadType.profileURL),
            make_field<OptionalField>(MakeKeyPath("user", "displayName"), payloadType.displayName),
            make_field<OptionalField>(MakeKeyPath("user", "login"), payloadType.login),
            make_field<OptionalField>(MakeKeyPath("user", "channel"), payloadType.channel)
        );
    }
};


struct ttv::broadcast::graphql::json::GetStreamKeyInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>("userId", inputParams.userId)
        );
    }
};


struct ttv::broadcast::graphql::json::GetStreamKeyStreamKeyResultStreamKeySchemaSelector
{
    static auto SelectSchema(const ttv::json::Value& value, ttv::Variant<GetStreamKeyQueryInfo::StreamKey, GetStreamKeyQueryInfo::StreamKeyError>& output)
    {
        auto& selectorKeyValue  = value["__typename"];
        if(selectorKeyValue.isNull() || !selectorKeyValue.isString()) {
            return false;
        }

        auto selectorKey = selectorKeyValue.asString();

        if(selectorKey == "StreamKey") {
            output = GetStreamKeyQueryInfo::StreamKey();
            auto& data = output.As<GetStreamKeyQueryInfo::StreamKey>();
            return ttv::json::ToObject<GetStreamKeyQueryInfo::StreamKey>(value, data);
        }

        if(selectorKey == "StreamKeyError") {
            output = GetStreamKeyQueryInfo::StreamKeyError();
            auto& data = output.As<GetStreamKeyQueryInfo::StreamKeyError>();
            return ttv::json::ToObject<GetStreamKeyQueryInfo::StreamKeyError>(value, data);
        }

        return false;
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::broadcast::graphql::GetStreamKeyQueryInfo::StreamKey>
{
    using Type = ObjectSchema<ttv::broadcast::graphql::json::GetStreamKeyStreamKey>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::broadcast::graphql::GetStreamKeyQueryInfo::StreamKeyError>
{
    using Type = ObjectSchema<ttv::broadcast::graphql::json::GetStreamKeyStreamKeyError>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::broadcast::graphql::GetStreamKeyQueryInfo::StreamKeyResult>
{
    using Type = ObjectSchema<ttv::broadcast::graphql::json::GetStreamKeyStreamKeyResult>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::broadcast::graphql::GetStreamKeyQueryInfo::VideoStreamSettings>
{
    using Type = ObjectSchema<ttv::broadcast::graphql::json::GetStreamKeyVideoStreamSettings>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::broadcast::graphql::GetStreamKeyQueryInfo::Channel>
{
    using Type = ObjectSchema<ttv::broadcast::graphql::json::GetStreamKeyChannel>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::broadcast::graphql::GetStreamKeyQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::broadcast::graphql::json::GetStreamKeyPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::broadcast::graphql::GetStreamKeyQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::broadcast::graphql::json::GetStreamKeyInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::Variant<ttv::broadcast::graphql::GetStreamKeyQueryInfo::StreamKey, ttv::broadcast::graphql::GetStreamKeyQueryInfo::StreamKeyError>>
{
    using Type = ttv::broadcast::graphql::json::GetStreamKeyStreamKeyResultStreamKeySchemaSelector;
};


