/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/iaudioframereceiver.h"

#include <memory>

namespace ttv {
namespace broadcast {
class IAacAudioFrameReceiver;
class AudioFrame;
}  // namespace broadcast
}  // namespace ttv

/**
 * Receives AAC audio data.
 */
class ttv::broadcast::IAacAudioFrameReceiver : public IAudioFrameReceiver {
 public:
  /**
   * Packages the given frame data so it can be enqueued for encoding.  When the frame processing of the frame is
   * complete the unlockCallback will be called.
   */
  virtual TTV_ErrorCode PackageFrame(const std::vector<uint8_t>& sampleBuffer, uint32_t numSamples,
    uint32_t numChannels, uint64_t timeStamp, std::shared_ptr<AudioFrame>& result) = 0;

  static ReceiverTypeId GetReceiverTypeId() {
    static int typeId = 0;
    return reinterpret_cast<ReceiverTypeId>(&typeId);
  }
};
