/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/iaudioframereceiver.h"

#include <memory>

namespace ttv {
namespace broadcast {
class IAudioMixer;
class AudioMixerProxy;
class AudioFrame;
}  // namespace broadcast
}  // namespace ttv

/**
 * The interface used for submitting audio data.
 */
class ttv::broadcast::IAudioMixer {
 public:
  virtual ~IAudioMixer() = default;

  virtual TTV_ErrorCode SubmitFrame(AudioLayerId audioLayerId, const std::shared_ptr<AudioFrame>& audioFrame) = 0;
  virtual bool SupportsReceiverProtocol(IAudioFrameReceiver::ReceiverTypeId typeId) const = 0;
  virtual std::shared_ptr<IAudioFrameReceiver> GetReceiverImplementation(
    IAudioFrameReceiver::ReceiverTypeId typeId) = 0;
};

class ttv::broadcast::AudioMixerProxy : public IAudioMixer {
 public:
  using SubmitFrameFunc =
    std::function<TTV_ErrorCode(AudioLayerId audioLayerId, const std::shared_ptr<AudioFrame>& audioFrame)>;
  using SupportsReceiverProtocolFunc = std::function<bool(IAudioFrameReceiver::ReceiverTypeId typeId)>;
  using GetReceiverImplementationFunc =
    std::function<std::shared_ptr<IAudioFrameReceiver>(IAudioFrameReceiver::ReceiverTypeId typeId)>;

 public:
  virtual TTV_ErrorCode SubmitFrame(AudioLayerId audioLayerId, const std::shared_ptr<AudioFrame>& audioFrame) override {
    return mSubmitFrameFunc(audioLayerId, audioFrame);
  }

  virtual bool SupportsReceiverProtocol(IAudioFrameReceiver::ReceiverTypeId typeId) const override {
    return mSupportsReceiverProtocolFunc(typeId);
  }

  virtual std::shared_ptr<IAudioFrameReceiver> GetReceiverImplementation(
    IAudioFrameReceiver::ReceiverTypeId typeId) override {
    return mGetReceiverImplementationFunc(typeId);
  }

 public:
  SubmitFrameFunc mSubmitFrameFunc;
  SupportsReceiverProtocolFunc mSupportsReceiverProtocolFunc;
  GetReceiverImplementationFunc mGetReceiverImplementationFunc;
};
