/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"

namespace ttv {
namespace broadcast {
class IFrameWriter;
struct Packet;
}  // namespace broadcast
}  // namespace ttv

/**
 * The interface used to submit encoded video and audio data.  This interface is thread-safe and
 * encoders may write packets from any thread.
 */
class ttv::broadcast::IFrameWriter {
 public:
  virtual ~IFrameWriter() = default;

 public:
  /**
   * Adds a packet to be written to the network that contains video or audio data.
   */
  virtual TTV_ErrorCode WritePacket(std::unique_ptr<Packet>&& packet) = 0;
};
