/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/audioframe.h"
#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/iaacaudioframereceiver.h"

namespace ttv {
namespace broadcast {
class AacAudioFrame;
class AacReceiver;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::AacAudioFrame : public AudioFrame {
 public:
  AacAudioFrame(
    const std::vector<uint8_t>& sampleBuffer, uint32_t numSamples, uint32_t numChannels, uint64_t timeStamp);

  const std::vector<uint8_t>& GetSampleBuffer() const { return mSampleBuffer; }
  uint32_t GetNumSamples() const { return mNumSamples; }
  uint32_t GetNumChannels() const { return mNumChannels; }

 private:
  std::vector<uint8_t> mSampleBuffer;
  uint32_t mNumSamples;
  uint32_t mNumChannels;
};

class ttv::broadcast::AacReceiver : public IAacAudioFrameReceiver {
 public:
  virtual TTV_ErrorCode PackageFrame(const std::vector<uint8_t>& sampleBuffer, uint32_t numSamples,
    uint32_t numChannels, uint64_t timeStamp, std::shared_ptr<AudioFrame>& result) override;
};
