/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/internal/audioconvert/audioconvertoptions.h"
#include "twitchsdk/broadcast/internal/audioconvert/converttofloatingpointoperator.h"
#include "twitchsdk/broadcast/internal/audioconvert/converttointegraltypeoperator.h"
#include "twitchsdk/broadcast/internal/audioconvert/converttosignedoperator.h"
#include "twitchsdk/broadcast/internal/audioconvert/converttounsignedoperator.h"
#include "twitchsdk/broadcast/internal/audioconvert/decreasebitdepthoperator.h"
#include "twitchsdk/broadcast/internal/audioconvert/dsputilities.h"
#include "twitchsdk/broadcast/internal/audioconvert/increasebitdepthoperator.h"
#include "twitchsdk/broadcast/internal/audioconvert/resampleoperator.h"

namespace ttv {
template <typename PassedOptions = void>
struct AudioConvertContext {
  using Options = AudioConvertOptionsDefaulter<PassedOptions>;

  template <typename Options>
  struct FilterOptionsProvider {
    static constexpr double Cutoff = Options::FilterCutoff;
    static constexpr size_t TapCount = Options::FilterTapCount;

    template <typename AudioOptions, typename Enable = void>
    struct WindowFunctionSelector {};

    template <typename AudioOptions>
    struct WindowFunctionSelector<AudioOptions, std::enable_if_t<AudioOptions::FilterType == FilterTypeEnum::Kaiser>> {
      struct KaiserParameters {
        static constexpr double Beta = AudioOptions::KaiserBeta;
        static constexpr size_t Length = AudioOptions::FilterTapCount;
      };

      using Type = KaiserBesselWindowFunctionGenerator<KaiserParameters>;
    };

    using WindowFunction = typename WindowFunctionSelector<Options>::Type;
  };

  using FilterOptions = FilterOptionsProvider<Options>;
};
}  // namespace ttv
