/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/errortypes.h"

#include <vector>

namespace ttv {
namespace broadcast {
struct IngestSampleData {
  struct Frame {
    Frame() : keyFrame(false) {}

    std::vector<uint8_t> data;
    bool keyFrame;
  };

  TTV_ErrorCode Parse(const uint8_t* buffer, size_t length);

  std::vector<uint8_t> spsData;
  std::vector<uint8_t> ppsData;
  std::vector<Frame> frames;

 private:
  TTV_ErrorCode TryParse(const uint8_t* buffer, size_t length);
  void Clear();
};
}  // namespace broadcast
}  // namespace ttv
