/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#ifndef IAMF0ENCODER_H
#define IAMF0ENCODER_H

#include "twitchsdk/broadcast/internal/muxers/amf0.h"

#include <vector>

namespace ttv {
namespace broadcast {
class AMF0Encoder;
}
}  // namespace ttv

/**
 * An implementation of AMF0 which encodes as binary data.
 */
class ttv::broadcast::AMF0Encoder : public IAMF0 {
 public:
  AMF0Encoder(void) {
    mBuffer.reserve(1024);  // arbitrary number to reduce allocations from small vectors
  }

  virtual ~AMF0Encoder(void) {}

  virtual void Number(double value);
  virtual void Boolean(bool flag);
  virtual void String(std::string param);
  virtual void Object();
  virtual void ObjectProperty(std::string propertyName);
  virtual void Movieclip();
  virtual void Null();
  virtual void Undefined();
  virtual void Reference();
  virtual void EcmaArray(uint32_t elements);
  virtual void EcmaArrayKey(std::string keyName);
  virtual void ObjectEnd();
  virtual void StrictArray(uint32_t elements);
  virtual void Date(double dateValue);
  virtual void LongString();
  virtual void Unsupported();
  virtual void Recordset();
  virtual void XmlDocument();
  virtual void TypedObject();

  const std::vector<uint8_t>& GetBuffer() const { return mBuffer; }

  void Reset() { mBuffer.resize(0); }

 private:
  template <typename _T>
  void EncodeToBuffer(_T param);
  std::vector<uint8_t> mBuffer;
};

#endif
