/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#ifndef FLVFORMAT_H
#define FLVFORMAT_H

namespace ttv {
namespace broadcast {
namespace flv {
struct Header;
struct TagHeader;
struct TagFooter;

enum TagTypes : uint8_t { Audio = 0x08, Video = 0x09, Meta = 0x12 };

using uint24_t = uint8_t[3];

#pragma pack(push)
#pragma pack(1)

struct Header {
  Header() : mSignature{0, 0, 0}, mVersion(0), mFlags(0), mHeaderSize(0) {}

  uint24_t mSignature;
  uint8_t mVersion;
  uint8_t mFlags;
  uint32_t mHeaderSize;
};

struct TagHeader {
  TagHeader()
      : mPacketType(Audio),
        mPacketLength{0, 0, 0},
        mPacketTimestamp{0, 0, 0},
        mPacketExtendedTimestamp(0),
        mStreamId{0, 0, 0} {}

  TagTypes mPacketType;
  uint24_t mPacketLength;
  uint24_t mPacketTimestamp;
  uint8_t mPacketExtendedTimestamp;
  uint24_t mStreamId;
};

struct TagFooter {
  TagFooter() : mLength(0) {}

  uint32_t mLength;  // Should be TagHeader.mPacketLength + sizeof (flv::TagHeader);
};

#pragma pack(pop)
}  // namespace flv
}  // namespace broadcast
}  // namespace ttv

#endif
