/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/internal/muxers/rtmpstate.h"

namespace ttv {
namespace broadcast {
class RtmpSendVideoState;
}
}  // namespace ttv

class ttv::broadcast::RtmpSendVideoState : public RtmpState {
 public:
  RtmpSendVideoState(RtmpContext* context) : RtmpState(context) {}

  virtual ~RtmpSendVideoState() {}

  TTV_ErrorCode BeginChunk(flv::TagHeader tagHeader);
  TTV_ErrorCode AddChunkData(const std::vector<uint8_t>& buffer);
  TTV_ErrorCode EndChunk();

 private:
  virtual void OnEnterInternal();
};
