/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/internal/muxers/rtmpstate.h"

namespace ttv {
namespace broadcast {
class RtmpShutdownState;
}
}  // namespace ttv

class ttv::broadcast::RtmpShutdownState : public RtmpState {
 public:
  RtmpShutdownState(RtmpContext* context) : RtmpState(context) {}

  virtual ~RtmpShutdownState() {}

 private:
  virtual uint64_t GetTimeoutDuration() const { return 5000; }

  virtual void OnEnterInternal();

  TTV_ErrorCode SendFCUnpublishMessage();
  TTV_ErrorCode SendDeleteStreamMessage();
};
