/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/muxers/rtmpcontext.h"
#include "twitchsdk/broadcast/internal/muxers/rtmpstate.h"

namespace ttv {
namespace broadcast {
class RtmpStream;
class RtmpState;
class StreamStats;
class RtmpMessageDetails;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::RtmpStream {
 public:
  RtmpStream(std::shared_ptr<StreamStats> streamStats);
  ~RtmpStream() {}

  void Start(const std::string& url);
  void Update();
  void Stop();

  TTV_ErrorCode BeginFLVChunk(flv::TagTypes type, uint32_t timestamp, size_t length);
  TTV_ErrorCode AddFLVData(const uint8_t* data, size_t length);
  TTV_ErrorCode EndFLVChunk();
  /**
   * If in the error state then this will return the error.
   */
  TTV_ErrorCode GetError();
  /**
   * Returns the average sending bit rate in bits per second over a sliding window.
   */
  TTV_ErrorCode GetAverageSendBitRate(uint64_t measurementWindowMilliseconds, uint64_t& bitsPerSecond) const {
    return mContext.mSocket.GetAverageSendBitRate(measurementWindowMilliseconds, bitsPerSecond);
  }
  /**
   * Returns the fraction of time spent blocking on the socket over a sliding window.
   */
  TTV_ErrorCode GetCongestionLevel(uint64_t measurementWindowMilliseconds, double& congestionLevel) const {
    return mContext.mSocket.GetCongestionLevel(measurementWindowMilliseconds, congestionLevel);
  }

 private:
  bool ChangeState();

  RtmpContext mContext;
  std::array<std::unique_ptr<RtmpState>, static_cast<uint32_t>(RtmpContext::State::Count)> mStates;

  RtmpMessageDetails mChunkDetails;
};
