/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/audioframe.h"
#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/ipcmaudioframereceiver.h"

namespace ttv {
namespace broadcast {
class PcmAudioFrame;
class PcmAudioReceiver;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::PcmAudioFrame : public AudioFrame {
 public:
  PcmAudioFrame(const uint8_t* sampleBuffer, uint32_t numSamplesPerChannel, uint32_t numChannels, bool interleaved,
    AudioSampleFormat audioSampleFormat, uint64_t timeStamp);

  const std::vector<uint8_t>& GetSampleBuffer() const { return mSampleBuffer; }
  AudioSampleFormat GetAudioSampleFormat() const { return mAudioSampleFormat; }
  uint32_t GetNumSamplesPerChannel() const { return mNumSamplesPerChannel; }
  bool GetInterleaved() const { return mInterleaved; }

 private:
  std::vector<uint8_t> mSampleBuffer;
  AudioSampleFormat mAudioSampleFormat;
  uint32_t mNumSamplesPerChannel;
  bool mInterleaved;
};

class ttv::broadcast::PcmAudioReceiver : public IPcmAudioFrameReceiver {
 public:
  PcmAudioReceiver(uint32_t numPcmSamplesPerFrame);

 public:
  virtual TTV_ErrorCode GetNumPcmSamplesPerFrame(uint32_t& result) const override;
  virtual TTV_ErrorCode PackageFrame(const uint8_t* sampleBuffer, uint32_t numSamplesPerChannel, uint32_t numChannels,
    bool interleaved, AudioSampleFormat audioSampleFormat, uint64_t timeStamp,
    std::shared_ptr<AudioFrame>& result) override;

 private:
  uint32_t mNumPcmSamplesPerFrame;
};
