/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/audioconstants.h"

namespace ttv {
namespace broadcast {
class PcmAudioMixer;
}
}  // namespace ttv

/**
 * Mixes PCM audio samples.  This is a simple class with many assumptions.  Do not try and use it with more than 2 audio
 * layers.
 */
class ttv::broadcast::PcmAudioMixer {
 public:
  PcmAudioMixer(uint32_t numChannels, uint32_t numSamplesPerChannelPerPacket);
  virtual ~PcmAudioMixer();

  // IAudioMixer implementation
  TTV_ErrorCode SubmitAudioSamples(const int16_t* data, uint64_t startTime, size_t length, float volume);
  TTV_ErrorCode GetNextPacketTime(uint64_t& nextPacketTime) const;
  /**
   * Retrieves the mixed audio.  The size of the returned packet will be the same as the numSamplesPerChannelPerPacket
   * value the class was created with.
   */
  TTV_ErrorCode GetPacket(int16_t* buffer, uint64_t& nextPacketTime);

 private:
  using buffer_t = std::vector<int32_t>;

  uint32_t mNumChannels;
  uint32_t mNumSamplesPerChannelPerPacket;  // The number of samples that will be returned in a call to GetPacket().
  buffer_t mMixerBuffer;
  uint64_t mNextPacketTime;
};
