/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace broadcast {
class ChannelInfoTask;
}
}  // namespace ttv

class ttv::broadcast::ChannelInfoTask : public ttv::HttpTask {
 public:
  struct Result {
    std::string streamKey;
    std::string loginName;
    std::string displayName;
    std::string url;
    ChannelId channelId;
  };

  using Callback =
    std::function<void(ChannelInfoTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  ChannelInfoTask(const std::string& oauthToken, Callback callback);

  virtual const char* GetTaskName() const override { return "ChannelInfoTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
};
