/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace broadcast {
class GameStreamsTask;
}
}  // namespace ttv

class ttv::broadcast::GameStreamsTask : public ttv::HttpTask {
 public:
  struct LiveGameStreamInfo {
    std::string channelUrl;
    std::string previewUrlTemplate;
    std::string streamTitle;
    std::string channelDisplayName;
    unsigned int viewerCount;
  };
  using LiveGameStreamList = std::vector<LiveGameStreamInfo>;

  struct Result {
    LiveGameStreamList streams;
  };

  using Callback =
    std::function<void(GameStreamsTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  GameStreamsTask(const std::string& gameName, uint limit, uint offset, Callback callback);

  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return "GameStreamsTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint status, const std::vector<char>& response) override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;

  std::string mGameName;
  uint mLimit;
  uint mOffset;
};
