/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/internal/twitchapi.h"
#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace broadcast {
class IngestListTask;
}
}  // namespace ttv

class ttv::broadcast::IngestListTask : public ttv::HttpTask {
 public:
  struct Result {
    std::vector<IngestServer> ingestList;
  };

  using Callback = std::function<void(IngestListTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  IngestListTask(ChannelId channelId, Callback callback);

  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return "IngestListTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;

 private:
  std::shared_ptr<Result> mResult;
  ChannelId mChannelId;
  Callback mCallback;
};
