/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace broadcast {
class MetaDataTask;
}
}  // namespace ttv

class ttv::broadcast::MetaDataTask : public ttv::HttpTask {
 public:
  enum class EventClass {
    Action,
    Start,
    End,
  };

  struct Result {};

  using Callback = std::function<void(MetaDataTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  MetaDataTask(const std::string& authToken, uint64_t streamId, EventClass eventClass, const std::string& name,
    int64_t streamTime, unsigned long sequenceNumber, const std::string& humanDescription, json::Value&& metaData,
    Callback callback);

  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return "MetaDataTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;

  uint64_t mStreamId;
  EventClass mEventClass;
  std::string mName;
  int64_t mStreamTime;
  unsigned long mSequenceNumber;
  std::string mHumanDescription;
  json::Value mMetaData;
};
