/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace broadcast {
class RecordingStatusTask;
}
}  // namespace ttv

class ttv::broadcast::RecordingStatusTask : public ttv::HttpTask {
 public:
  struct Result {
    Result();

    ArchivingState state;
  };

  using Callback =
    std::function<void(RecordingStatusTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  RecordingStatusTask(const std::string& oauthToken, Callback callback);

  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return "RecordingStatusTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint status, const std::vector<char>& response) override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
};
