/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace broadcast {
class RunCommercialTask;
}
}  // namespace ttv

// TODO: Add support for timebreak

class ttv::broadcast::RunCommercialTask : public ttv::HttpTask {
 public:
  struct Result {};

  using Callback =
    std::function<void(RunCommercialTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  RunCommercialTask(ChannelId channelId, const std::string& authToken, Callback callback);

  virtual void OnComplete() override;
  virtual const char* GetTaskName() const override { return "RunCommercialTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  ChannelId mChannelId;
};
