/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace broadcast {
class SetStreamInfoTask;
}
}  // namespace ttv

/**
 * Sets the stream title and game name for a channel.
 */
class ttv::broadcast::SetStreamInfoTask : public ttv::HttpTask {
 public:
  struct Result {};

  using Callback =
    std::function<void(SetStreamInfoTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  SetStreamInfoTask(ChannelId channelId, const std::string& oauthToken, const std::string& streamTitle,
    const std::string& gameName, Callback callback);

  virtual const char* GetTaskName() const override { return "SetStreamInfoTask"; }

 protected:
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void OnComplete() override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  ChannelId mChannelId;
  std::string mStreamTitle;
  std::string mGameName;
};
