/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/videoframe.h"

#include <list>

namespace ttv {
class IThread;
class IMutex;

namespace broadcast {
class VideoFrameQueue;
}
}  // namespace ttv

class ttv::broadcast::VideoFrameQueue {
 public:
  VideoFrameQueue();

  void SetFPS(uint fps);
  TTV_ErrorCode AddFrame(const std::shared_ptr<VideoFrame>& frame);
  std::shared_ptr<VideoFrame> GetNextFrame(uint64_t currentTime);
  void Shutdown();

  /**
   * Frame dropping and reuse should be allowed for scenarios that have real encoders encoding frames.
   * When using passthrough capturers and encodeers this should be false so that no frames
   * are dropped or submitted multiple times.
   */
  void SetAllowFrameDroppingAndReuse(bool allow) { mAllowFrameDroppingAndReuse = allow; }

 private:
  std::unique_ptr<IMutex> mMutex;
  std::list<std::shared_ptr<VideoFrame>>
    mQueuedVideoFrames;  // If frame dropping is allowed then this will have at most one frame in it.

  // Member used when allowing drops and reuse
  std::shared_ptr<VideoFrame> mLastProcessedFrame;  // The last frame that was returned from GetNextFrame().

  uint mNumFramesDropped;
  uint mNumFramesProcessed;

  uint64_t mFrameDuration;
  uint64_t mTimeOfNextFrame;
  uint64_t mTimeOfNextKeyFrame;
  uint64_t mTimeOfLastSubmittedFrame;

  bool mAllowFrameDroppingAndReuse;
};
