/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"

#include <memory>

namespace ttv {
class IThread;

namespace broadcast {
class IVideoEncoder;
class VideoFrameQueue;
class IVideoCapture;
class VideoStreamer;
class VideoFrame;
class FlvMuxer;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::VideoStreamer {
 public:
  VideoStreamer();
  ~VideoStreamer();

 public:
  TTV_ErrorCode SetEncoder(const std::shared_ptr<IVideoEncoder>& encoder);
  TTV_ErrorCode SetCapturer(const std::shared_ptr<IVideoCapture>& capturer);
  TTV_ErrorCode Initialize(const VideoParams& videoParams);
  TTV_ErrorCode StartCapture();
  TTV_ErrorCode ProcessFrame(const std::shared_ptr<VideoFrame>& videoFrame);
  /**
   * Synchronously stops the processing of frames and stops the encoder.
   */
  TTV_ErrorCode Stop();

  TTV_ErrorCode ValidateVideoParams(const VideoParams& videoParams) const;

  void SetInitialTime(uint64_t initialTime);

  std::string GetEncoderName() const;

 private:
  TTV_ErrorCode OpenVideo(const VideoParams* videoParams);
  void ProcessFrameQueue();

 private:
  uint64_t mInitialTime;

  volatile bool mDoProcessing;

  std::shared_ptr<IVideoEncoder> mVideoEncoder;
  std::shared_ptr<IVideoCapture> mVideoCapturer;
  std::unique_ptr<VideoFrameQueue> mFrameQueue;
  std::shared_ptr<IThread> mFrameQueueThread;
  VideoParams mVideoParams;
};
