/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"

namespace ttv {
namespace broadcast {
class WaveFileWriter;
}
}  // namespace ttv

class ttv::broadcast::WaveFileWriter {
 public:
  WaveFileWriter();
  ~WaveFileWriter();

  bool Open(const std::string& path, uint sampleRate, uint numChannels, bool isFloat);
  bool WriteSamples(const float* samples, uint numSamples);
  bool WriteSamples(const int16_t* samples, uint numSamples);
  bool Close();

  float GetDuration() const { return mDuration; }

 private:
  void WriteWaveHeader(uint fileLength);

  FILE* mFile;
  uint mSampleRate;
  uint mNumChannels;
  float mDuration;
  bool mIsFloat;
};
