/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/iaudioframereceiver.h"

#include <memory>

namespace ttv {
namespace broadcast {
class IPcmAudioFrameReceiver;
class AudioFrame;
}  // namespace broadcast
}  // namespace ttv

/**
 * Receives PCM audio data.
 */
class ttv::broadcast::IPcmAudioFrameReceiver : public IAudioFrameReceiver {
 public:
  /**
   * Retrieves the supported number of PCM audio samples per audio frame.  This should be numSamplesPerChannel *
   * numChannels when packaging a frame.
   */
  virtual TTV_ErrorCode GetNumPcmSamplesPerFrame(uint32_t& result) const = 0;

  /**
   * Packages the given frame data so it can be enqueued for encoding.  When the frame processing of the frame is
   * complete the unlockCallback will be called.  The sampleBuffer will be copied so it can safely be used after this
   * call returns.  numSamplesPerChannel * numChannels should be the same as the value returned from
   * GetNumPcmSamplesPerFrame().
   */
  virtual TTV_ErrorCode PackageFrame(const uint8_t* sampleBuffer, uint32_t numSamplesPerChannel, uint32_t numChannels,
    bool interleaved, AudioSampleFormat audioSampleFormat, uint64_t timeStamp, std::shared_ptr<AudioFrame>& result) = 0;

  static ReceiverTypeId GetReceiverTypeId() {
    static int typeId = 0;
    return reinterpret_cast<ReceiverTypeId>(&typeId);
  }
};
