/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/iaudioframereceiver.h"

#include <memory>

namespace ttv {
namespace broadcast {
class IPreEncodedAudioFrameReceiver;
class AudioFrame;
}  // namespace broadcast
}  // namespace ttv

/**
 * Receives an audio frame that has already been encoded.
 */
class ttv::broadcast::IPreEncodedAudioFrameReceiver : public IAudioFrameReceiver {
 public:
  using AudioPacket = std::vector<uint8_t>;

 public:
  /**
   * Packages the given frame data so it can be enqueued for encoding.
   */
  virtual TTV_ErrorCode PackageFrame(AudioPacket&& frameData, AudioFormat audioFormat, uint32_t numChannels,
    uint64_t timeStamp, std::shared_ptr<AudioFrame>& result) = 0;

  static ReceiverTypeId GetReceiverTypeId() {
    static int typeId = 0;
    return reinterpret_cast<ReceiverTypeId>(&typeId);
  }
};
