/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/ivideoframereceiver.h"

#include <memory>

namespace ttv {
namespace broadcast {
class IPreEncodedVideoFrameReceiver;
class VideoFrame;
}  // namespace broadcast
}  // namespace ttv

/**
 * Receives a video frame that has already been encoded.
 */
class ttv::broadcast::IPreEncodedVideoFrameReceiver : public IVideoFrameReceiver {
 public:
  using VideoPacket = std::vector<uint8_t>;

 public:
  /**
   * Packages the given frame data so it can be enqueued for encoding.
   */
  virtual TTV_ErrorCode PackageFrame(
    VideoPacket&& frameData, bool keyFrame, uint64_t timeStamp, std::shared_ptr<VideoFrame>& result) = 0;

  static ReceiverTypeId GetReceiverTypeId() {
    static int typeId = 0;
    return reinterpret_cast<ReceiverTypeId>(&typeId);
  }
};
