/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"

#include <memory>

namespace ttv {
namespace broadcast {
class IVideoFrameQueue;
class VideoFrame;
}  // namespace broadcast
}  // namespace ttv

/**
 * The interface used for submitting video frames for encoding.
 */
class ttv::broadcast::IVideoFrameQueue {
 public:
  virtual ~IVideoFrameQueue() = default;

 public:
  /**
   * Adds the given frame to the queue.
   */
  virtual TTV_ErrorCode AddVideoFrame(const std::shared_ptr<VideoFrame>& frame) = 0;
};
