/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"

#include <vector>

namespace ttv {
namespace broadcast {
struct Packet;
}
}  // namespace ttv

/**
 * A data blob to be inserted into an FLV stream.
 */
struct ttv::broadcast::Packet {
  Packet() : timestamp(0), cts(0), streamIndex(0), keyframe(false), sequenceHeader(false) {}

  std::vector<uint8_t> data;
  uint64_t timestamp;
  uint32_t cts;
  uint32_t streamIndex;
  bool keyframe;
  bool sequenceHeader;  // TODO: This is AVC specific but I don't have a better idea right now
};
