/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/audiocapturebase.h"
#include "twitchsdk/core/concurrentqueue.h"

#include <vector>

namespace ttv {
class IThread;

namespace broadcast {
class PassThroughAudioCapture;
}
}  // namespace ttv

class ttv::broadcast::PassThroughAudioCapture : public AudioCaptureBase {
 public:
  PassThroughAudioCapture();

  TTV_ErrorCode SetAudioFormat(AudioFormat format);
  TTV_ErrorCode SetNumChannels(uint32_t numChannels);
  TTV_ErrorCode EnqueueAudioPacket(std::vector<uint8_t>&& videoPacket, uint64_t timestamp);

 public:
  // IAudioCapture implementation
  virtual std::string GetName() const override;
  virtual uint32_t GetNumChannels() const override;
  virtual TTV_ErrorCode Process(const std::shared_ptr<IAudioMixer>& mixer, uint64_t& lastSampleTime) override;
  virtual TTV_ErrorCode Stop() override;

 private:
  struct QueueEntry {
    std::vector<uint8_t> packet;
    uint64_t timestamp;
  };

  ConcurrentQueue<std::shared_ptr<QueueEntry>> mAudioPacketQueue;
  AudioFormat mAudioFormat;
  uint32_t mNumChannels;
};
