/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/iaudioencoder.h"

#include <vector>

namespace ttv {
namespace broadcast {
class PassThroughAudioEncoder;
class PassThroughAudioEncoderInternalData;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::PassThroughAudioEncoder : public IAudioEncoder {
 public:
  PassThroughAudioEncoder();
  virtual ~PassThroughAudioEncoder() override;

  TTV_ErrorCode SetAudioFormat(AudioFormat format);
  TTV_ErrorCode SetSamplesPerFrame(uint32_t samplesPerFrame);

 public:
  // IAudioEncoder Implementation
  virtual std::string GetName() const override;
  virtual TTV_ErrorCode SetFrameWriter(const std::shared_ptr<IFrameWriter>& frameWriter) override;
  virtual TTV_ErrorCode GetAudioEncodingFormat(AudioFormat& result) override;
  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Start(uint32_t streamIndex, const AudioParams& audioParams) override;
  virtual TTV_ErrorCode GetNumInputSamplesPerEncodeFrame(uint32_t& result) override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode Shutdown() override;

  virtual TTV_ErrorCode SubmitFrame(const std::shared_ptr<AudioFrame>& audioFrame) override;
  virtual bool SupportsReceiverProtocol(IAudioFrameReceiver::ReceiverTypeId typeId) const override;
  virtual std::shared_ptr<IAudioFrameReceiver> GetReceiverImplementation(
    IAudioFrameReceiver::ReceiverTypeId typeId) override;

 private:
  std::shared_ptr<PassThroughAudioEncoderInternalData> mInternalData;
};
