/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/ivideocapture.h"
#include "twitchsdk/core/concurrentqueue.h"

#include <condition_variable>

#include <mutex>
#include <vector>

namespace ttv {
class IThread;

namespace broadcast {
class PassThroughVideoCapture;
class IPreEncodedVideoFrameReceiver;
}  // namespace broadcast
}  // namespace ttv

class ttv::broadcast::PassThroughVideoCapture : public IVideoCapture {
 public:
  PassThroughVideoCapture();

  TTV_ErrorCode EnqueueVideoPacket(std::vector<uint8_t>&& videoPacket, bool keyframe, uint64_t timestamp);

 public:
  // IVideoCapture Implementation
  virtual std::string GetName() const override;
  virtual TTV_ErrorCode SetVideoEncoder(const std::shared_ptr<IVideoEncoder>& encoder) override;
  virtual TTV_ErrorCode SetFrameQueue(const std::shared_ptr<IVideoFrameQueue>& queue) override;
  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Start(const VideoParams& videoParams) override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode Shutdown() override;

 private:
  struct QueueEntry {
    std::vector<uint8_t> packet;
    uint64_t timestamp;
    bool keyframe;
  };

  std::shared_ptr<IVideoEncoder> mVideoEncoder;
  std::shared_ptr<IVideoFrameQueue> mFrameQueue;
  std::shared_ptr<IPreEncodedVideoFrameReceiver> mReceiver;
  std::shared_ptr<IThread> mThread;
  VideoParams mVideoParams;

  ConcurrentQueue<std::shared_ptr<QueueEntry>> mVideoPacketQueue;

  std::mutex mMutex;
  std::condition_variable mCondition;

  bool mInitialized;
  bool mStarted;
};
