/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/ivideoframereceiver.h"

#include <functional>

namespace ttv {
namespace broadcast {
class VideoFrame;
}
}  // namespace ttv

/**
 * The container for video data to be encoded.  This class will be extended to hold implementation-specific data.
 */
class ttv::broadcast::VideoFrame {
 public:
  using UnlockFunc = std::function<void()>;

 public:
  virtual ~VideoFrame();

  void SetTimeStamp(uint64_t timeStamp) { mTimeStamp = timeStamp; }
  uint64_t GetTimeStamp() const { return mTimeStamp; }

  void SetIsKeyFrame(bool isKeyFrame) { mIsKeyFrame = isKeyFrame; }
  bool IsKeyFrame() const { return mIsKeyFrame; }

  void SetVerticalFlip(bool flip) { mVerticalFlip = flip; }
  bool GetVerticalFlip() const { return mVerticalFlip; }

  void SetFrameIndex(uint32_t frameIndex) { mFrameIndex = frameIndex; }
  uint32_t GetFrameIndex() const { return mFrameIndex; }

  /**
   * Returns the type id of the receiver that packaged the VideoFrame.
   */
  IVideoFrameReceiver::ReceiverTypeId GetReceiverTypeId() const { return mReceiverTypeId; }

 protected:
  VideoFrame(IVideoFrameReceiver::ReceiverTypeId receiverTypeId);

  void SetUnlockCallback(UnlockFunc callback) { mUnlockCallback = callback; }

 private:
  UnlockFunc mUnlockCallback;
  IVideoFrameReceiver::ReceiverTypeId mReceiverTypeId;
  uint64_t mTimeStamp;
  uint32_t mFrameIndex;
  bool mIsKeyFrame;
  bool mVerticalFlip;
};
