/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/audiocapturebase.h"
#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/ipcmaudioframereceiver.h"

#include <atomic>

namespace ttv {
namespace broadcast {
namespace test {
class TestAudioCapturer;
}
}  // namespace broadcast
}  // namespace ttv

/**
 * A simple audio frame generator which generates a sine wave.
 */
class ttv::broadcast::test::TestAudioCapturer : public AudioCaptureBase {
 public:
  TestAudioCapturer();
  virtual ~TestAudioCapturer();

  // IAudioCapture implementation
  virtual std::string GetName() const override;
  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Shutdown() override;
  virtual TTV_ErrorCode Start() override;
  uint32_t GetNumChannels() const override;
  virtual TTV_ErrorCode Process(const std::shared_ptr<IAudioMixer>& mixer, uint64_t& lastSampleTime) override;

 private:
  std::shared_ptr<IPcmAudioFrameReceiver> mReceiver;
  std::vector<int16_t> mBuffer;
  uint64_t mSampleTime;
  uint64_t mLastProcessTime;
  float mWaveFormProgress;
  float mPitchProgress;
};
