/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/ivideocapture.h"

#include <atomic>
#include <vector>

namespace ttv {
class IThread;

namespace broadcast {
class IRawVideoFrameReceiver;
class IVideoEncoder;

namespace test {
class TestVideoCapturer;
}
}  // namespace broadcast
}  // namespace ttv

/**
 * A simple video frame generator which generates solid frames and transitions between colors.
 */
class ttv::broadcast::test::TestVideoCapturer : public IVideoCapture {
 public:
  TestVideoCapturer();
  virtual ~TestVideoCapturer();

  // IVideoFrameGenerator implementation
  virtual std::string GetName() const override;
  virtual TTV_ErrorCode SetVideoEncoder(const std::shared_ptr<IVideoEncoder>& encoder) override;
  virtual TTV_ErrorCode SetFrameQueue(const std::shared_ptr<IVideoFrameQueue>& queue) override;
  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Start(const VideoParams& videoParams) override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode Shutdown() override;

 protected:
  virtual void GenerateFrame(uint8_t* buffer, PixelFormat& pixelFormat, bool& requiresVerticalFlip);

  VideoParams mVideoParams;

 private:
  std::shared_ptr<IVideoEncoder> mVideoEncoder;
  std::shared_ptr<IRawVideoFrameReceiver> mRawVideoFrameReceiver;
  std::shared_ptr<IVideoFrameQueue> mFrameQueue;
  std::shared_ptr<IThread> mThread;    // The worker thread submitting frames to the frame queue.
  std::vector<uint8_t*> mAllBuffers;   // The pool of all allocated buffers.
  std::vector<uint8_t*> mFreeBuffers;  // The pool of free buffers.
  std::atomic_bool mSubmitting;
  std::atomic_bool mShutdown;

  uint32_t mColor1;
  uint32_t mColor2;
  float mTime;
};
