/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/aacaudioframe.h"

#include "twitchsdk/broadcast/ipcmaudioframereceiver.h"

ttv::broadcast::AacAudioFrame::AacAudioFrame(
  const std::vector<uint8_t>& sampleBuffer, uint32_t numSamples, uint32_t numChannels, uint64_t timeStamp)
    : AudioFrame(IPcmAudioFrameReceiver::GetReceiverTypeId()),
      mSampleBuffer(sampleBuffer),
      mNumSamples(numSamples),
      mNumChannels(numChannels) {
  SetTimeStamp(timeStamp);
}

TTV_ErrorCode ttv::broadcast::AacReceiver::PackageFrame(const std::vector<uint8_t>& sampleBuffer, uint32_t numSamples,
  uint32_t numChannels, uint64_t timeStamp, std::shared_ptr<AudioFrame>& result) {
  result = std::make_shared<AacAudioFrame>(sampleBuffer, numSamples, numChannels, timeStamp);

  return TTV_EC_SUCCESS;
}
