/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/audioframe.h"

ttv::broadcast::AudioFrame::AudioFrame(IAudioFrameReceiver::ReceiverTypeId receiverTypeId)
    : mReceiverTypeId(receiverTypeId),
      mAudioFormat(AudioFormat::PCM),
      mTimeStamp(0),
      mNumChannels(2),
      mSampleRateHz(0) {}

ttv::broadcast::AudioFrame::~AudioFrame() {
  if (mUnlockCallback != nullptr) {
    mUnlockCallback();
  }
}
