/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/bandwidthreport.h"

#include <sstream>

void ttv::broadcast::BandwidthReport::ReceivedBandwidthStat(const ttv::broadcast::BandwidthStat& stat) {
  mStats.push_back(stat);
}

std::string ttv::broadcast::BandwidthReport::DumpCsvData() {
  std::ostringstream stream;
  stream << "StreamTime,RecommendedBPS,MeasuredBPS,EncodedBPS,BackBufferSize,CongestionLevel" << std::endl;

  for (const auto& stat : mStats) {
    stream << stat.recordedTime << ",";
    stream << stat.recommendedBitsPerSecond << ",";
    stream << stat.measuredBitsPerSecond << ",";
    stream << stat.encoderOutputBitsPerSecond << ",";
    stream << stat.backBufferSeconds << ",";
    stream << stat.congestionLevel << ",";
    stream << std::endl;
  }

  return stream.str();
}

void ttv::broadcast::BandwidthReport::Clear() {
  mStats.clear();
}
