/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/muxers/amf0encoder.h"

//-----------------------------------------------------------------------------
template <typename encoding_t>
void ttv::broadcast::AMF0Encoder::EncodeToBuffer(encoding_t param) {
  auto p = reinterpret_cast<uint8_t*>(&param);

  for (int i = sizeof(encoding_t) - 1; i >= 0; --i) {
    mBuffer.push_back(p[i]);
  }
}

// lint -esym(1023,std::vector<unsigned char>::push_back) ambiguous .push_back(const T&) vs .push_back(T&&), but the C++
// Standard says T&& gets priority so that is the one that is used. lint -esym(1703,std::vector<unsigned
// char>::push_back) Function arbitrarily selected.  Refer to Error 1023 lint -e1961 virtual member function ___ could
// be made const (for all the unimplemented methods)

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Number(double value) {
  mBuffer.push_back(number);
  EncodeToBuffer(value);
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Boolean(bool flag) {
  mBuffer.push_back(boolean);
  mBuffer.push_back(flag ? 1 : 0);  // lint !e917 Prototype coercion int to unsigned char
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::String(std::string param) {
  mBuffer.push_back(string);
  EncodeToBuffer(static_cast<int16_t>(param.length()));
  mBuffer.insert(mBuffer.end(), param.cbegin(), param.cend());
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Object() {
  mBuffer.push_back(object);
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::ObjectProperty(std::string propertyName) {
  EncodeToBuffer(static_cast<int16_t>(propertyName.length()));
  mBuffer.insert(mBuffer.end(), propertyName.cbegin(), propertyName.cend());
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Movieclip() {
  assert(false && "unsupported");  // lint !e909 Implicit conversion from array to bool
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Null() {
  mBuffer.push_back(null);
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Undefined() {
  assert(false && "unsupported");  // lint !e909 Implicit conversion from array to bool
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Reference() {
  assert(false && "unimplemented");  // lint !e909 Implicit conversion from array to bool
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::EcmaArray(uint32_t elements) {
  mBuffer.push_back(ecmaArray);
  EncodeToBuffer(elements);
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::EcmaArrayKey(std::string keyName) {
  EncodeToBuffer(static_cast<int16_t>(keyName.length()));
  mBuffer.insert(mBuffer.end(), keyName.cbegin(), keyName.cend());
}
//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::ObjectEnd() {
  mBuffer.push_back(0);  // lint !e917 Converting an int to a unsigned char
  mBuffer.push_back(0);  // lint !e917 Converting an int to a unsigned char
  mBuffer.push_back(objectEnd);
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::StrictArray(uint32_t elements) {
  mBuffer.push_back(strictArray);
  EncodeToBuffer(elements);
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Date(double dateValue) {
  mBuffer.push_back(date);

  // AMF Spec says to always use 0 as the timezone.
  const uint16_t timeZone = 0;  // lint !e915 Converting an int to a unsigned short
  EncodeToBuffer(dateValue);
  EncodeToBuffer(timeZone);
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::LongString() {
  assert(false && "unimplemented");  // lint !e909 Implicit conversion from array to bool
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Unsupported() {
  assert(false && "unsupported");  // lint !e909 Implicit conversion from array to bool
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::Recordset() {
  assert(false && "unimplemented");  // lint !e909 Implicit conversion from array to bool
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::XmlDocument() {
  assert(false && "unimplemented");  // lint !e909 Implicit conversion from array to bool
}

//-----------------------------------------------------------------------------
void ttv::broadcast::AMF0Encoder::TypedObject() {
  assert(false && "unimplemented");  // lint !e909 Implicit conversion from array to bool
}
