/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/muxers/rtmpconnectstate.h"

//-----------------------------------------------------------------------------
void ttv::broadcast::RtmpConnectState::OnEnterInternal() {
  GetContext()->mAmfEncoder.Reset();

  GetContext()->mAmfEncoder.String("connect");
  GetContext()->mAmfEncoder.Number(GetContext()->mTransactionId++);
  GetContext()->mAmfEncoder.Object();
  GetContext()->mAmfEncoder.ObjectProperty("app");
  GetContext()->mAmfEncoder.String(GetContext()->mApplication);
  GetContext()->mAmfEncoder.ObjectProperty("type");
  GetContext()->mAmfEncoder.String("nonprivate");
  GetContext()->mAmfEncoder.ObjectProperty("tcUrl");
  GetContext()->mAmfEncoder.String(GetContext()->mURL);
  GetContext()->mAmfEncoder.ObjectEnd();

  RtmpMessageDetails details(
    RTMP_CHANNEL_SYSTEM, 0, static_cast<uint32_t>(GetContext()->mAmfEncoder.GetBuffer().size()), RTMP_PKT_AMF0, 0);

  TTV_ErrorCode ret = SendChunkData(GetContext()->mAmfEncoder.GetBuffer(), details);
  ASSERT_ON_ERROR(ret);

  if (TTV_SUCCEEDED(ret)) {
    ret = GetContext()->mSocket.FlushCache();
    ASSERT_ON_ERROR(ret);
  }

  if (TTV_FAILED(ret)) {
    GetContext()->SetNextState(RtmpContext::State::Error);
    GetContext()->mLastError = ret;
  }
}

//-----------------------------------------------------------------------------
void ttv::broadcast::RtmpConnectState::HandleIncomingAmf0(ChunkHeader /*header*/, const uint8_t* data) {
  std::shared_ptr<AMF0StringDecoder> stringDecoder(new AMF0StringDecoder());
  data = DecodeAMF(data, stringDecoder);

  // Skip over the number
  std::shared_ptr<AMF0Nop> nopDecoder = std::make_shared<AMF0Nop>();
  data = DecodeAMF(data, nopDecoder);

  // command meta data
  data = DecodeAMF(data, nopDecoder);

  if (strcasecmp(stringDecoder->GetCommandName().c_str(), "_result") == 0) {
    std::shared_ptr<AMF0PropertyDecoder> propertyDecoder(new AMF0PropertyDecoder("code"));
    data = DecodeAMF(data, propertyDecoder);

    if (strcasecmp(propertyDecoder->GetFoundValue().c_str(), "NetConnection.Connect.Success") == 0) {
      GetContext()->SetNextState(RtmpContext::State::CreateStream);
    } else {
      ttv::trace::Message("rtmp", MessageLevel::Error, "Unexpected result returned during connect!");
      GetContext()->SetNextState(RtmpContext::State::Error);
    }
  }

  (void)data;  // We don't care about data's value
}
