/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/muxers/rtmpcontext.h"

#include "twitchsdk/broadcast/broadcasttypes.h"
#include "twitchsdk/broadcast/internal/muxers/rtmp.h"

ttv::broadcast::RtmpContext::RtmpContext(std::shared_ptr<StreamStats> streamStats)
    : mURL(""),
      mHostName(""),
      mApplication(""),
      mPort(0),
      mStreamName(""),
      mIncomingChunkSize(RTMP_DEFAULT_CHUNK_SIZE),
      mOutgoingChunkSize(RTMP_DEFAULT_CHUNK_SIZE),
      mWindowAckSize(0),
      mIncomingPeerBW(0),
      mChunkSpace(0),
      mTransactionId(0.0),
      mStreamId(0.0),
      mLastError(TTV_EC_SUCCESS),
      mAmfEncoder(),
      mStreamStats(streamStats),
      mCurrentState(State::Invalid),
      mNextState(State::Idle) {
  assert(mStreamStats);
}

void ttv::broadcast::RtmpContext::OnStateChange() {
  assert(mChunkSpace == 0);

  if (mNextState == State::Error) {
    assert(mLastError != TTV_EC_SUCCESS);
  } else {
    assert(mLastError == TTV_EC_SUCCESS);
  }
}

void ttv::broadcast::RtmpContext::SetNextState(State nextState) {
  if (nextState == mCurrentState) {
    return;
  }

#if _DEBUG
  if (nextState == State::Error) {
    auto asdfs = rand();
  }
#endif

  TTV_ASSERT(nextState >= State::Invalid && nextState < State::Count);
  if (nextState >= State::Invalid && nextState < State::Count) {
    mNextState = nextState;
  }
  ttv::trace::Message("rtmp", MessageLevel::Debug, "Setting next state to %d", mNextState);
}
