/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/muxers/rtmphandshakestate.h"

void ttv::broadcast::RtmpHandshakeState::OnEnterInternal() {
  auto& sock = GetContext()->mSocket;

  uint8_t C0 = 0x3;  // RTMP version
  TTV_ErrorCode ret = sock.Send(&C0, sizeof(C0), true);
  if (TTV_FAILED(ret)) {
    GetContext()->mLastError = ret;
    GetContext()->SetNextState(RtmpContext::State::Error);
    return;
  }

  std::vector<uint8_t> C1;
  C1.resize(1536);

  // C1 Format
  // 32 bit timestamp - we leave as 0
  // 32 bit version - we leave at 0 to indicate we are not
  //                  the authentic adobe client
  // rest of the data is for authentication which we don't
  // do
  //

  ret = sock.Send(C1.data(), C1.size(), false);
  if (TTV_FAILED(ret)) {
    GetContext()->mLastError = ret;
    GetContext()->SetNextState(RtmpContext::State::Error);
    return;
  }

  uint8_t S0;
  std::vector<uint8_t> S1;
  S1.resize(1536);

  size_t received;

  ret = sock.Recv(&S0, sizeof(S0), received, 5000);
  if (TTV_FAILED(ret)) {
    GetContext()->mLastError = ret;
    GetContext()->SetNextState(RtmpContext::State::Error);
    return;
  } else {
    TTV_ASSERT(received == sizeof(S0));
  }

  ret = sock.Recv(S1.data(), S1.size(), received, 5000);
  if (TTV_FAILED(ret)) {
    GetContext()->mLastError = ret;
    GetContext()->SetNextState(RtmpContext::State::Error);
    return;
  } else {
    TTV_ASSERT(received == S1.size());
  }

  ret = sock.Send(S1.data(), S1.size(), false);
  if (TTV_FAILED(ret)) {
    GetContext()->mLastError = ret;
    GetContext()->SetNextState(RtmpContext::State::Error);
    return;
  }

  std::vector<uint8_t> S2;
  S2.resize(1536);

  ret = sock.Recv(S2.data(), S2.size(), received, 5000);

  if (TTV_FAILED(ret)) {
    GetContext()->mLastError = ret;
    GetContext()->SetNextState(RtmpContext::State::Error);
    return;
  } else {
    TTV_ASSERT(received == S2.size());
  }

  GetContext()->SetNextState(RtmpContext::State::Connect);
}
