/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/muxers/rtmppublishstate.h"

void ttv::broadcast::RtmpPublishState::OnEnterInternal() {
  GetContext()->mAmfEncoder.Reset();

  GetContext()->mAmfEncoder.String("publish");
  GetContext()->mAmfEncoder.Number(GetContext()->mTransactionId++);
  GetContext()->mAmfEncoder.Null();
  GetContext()->mAmfEncoder.String(GetContext()->mStreamName);
  GetContext()->mAmfEncoder.String("live");

  RtmpMessageDetails details(
    RTMP_CHANNEL_NETSTREAM, 0, static_cast<uint32_t>(GetContext()->mAmfEncoder.GetBuffer().size()), RTMP_PKT_AMF0, 1);

  TTV_ErrorCode ret = SendChunkData(GetContext()->mAmfEncoder.GetBuffer(), details);
  ASSERT_ON_ERROR(ret);

  if (TTV_FAILED(ret)) {
    GetContext()->SetNextState(RtmpContext::State::Error);
    GetContext()->mLastError = ret;
  }

  ret = GetContext()->mSocket.FlushCache();
  if (TTV_FAILED(ret)) {
    GetContext()->SetNextState(RtmpContext::State::Error);
    GetContext()->mLastError = ret;
  }
}

void ttv::broadcast::RtmpPublishState::HandleIncomingAmf0(ChunkHeader /*header*/, const uint8_t* data) {
  std::shared_ptr<AMF0StringDecoder> stringDecoder(new AMF0StringDecoder());
  data = DecodeAMF(data, stringDecoder);

  // Skip over the number
  std::shared_ptr<AMF0Nop> nopDecoder(new AMF0Nop());
  data = DecodeAMF(data, nopDecoder);

  // command meta data
  data = DecodeAMF(data, nopDecoder);

  if (strcasecmp(stringDecoder->GetCommandName().c_str(), "onStatus") == 0) {
    std::shared_ptr<AMF0PropertyDecoder> propertyDecoder(new AMF0PropertyDecoder("code"));
    data = DecodeAMF(data, propertyDecoder);

    if (strcasecmp(propertyDecoder->GetFoundValue().c_str(), "NetStream.Publish.Start") == 0) {
      GetContext()->SetNextState(RtmpContext::State::SendVideo);
    } else if (strcasecmp(propertyDecoder->GetFoundValue().c_str(), "NetStream.Publish.Rejected") == 0) {
      ttv::trace::Message("rtmp", MessageLevel::Error, "Stream rejected during publish!");

      GetContext()->mLastError = TTV_EC_BROADCAST_RTMP_REJECTED;
      GetContext()->SetNextState(RtmpContext::State::Error);
    } else {
      ttv::trace::Message("rtmp", MessageLevel::Error, "Unexpected result returned during publish!");
      GetContext()->mLastError = TTV_EC_UNKNOWN_ERROR;
      GetContext()->SetNextState(RtmpContext::State::Error);
    }
  }

  (void)data;  // We don't care about data's value
}
