/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/muxers/rtmpshutdownstate.h"

TTV_ErrorCode ttv::broadcast::RtmpShutdownState::SendFCUnpublishMessage() {
  GetContext()->mAmfEncoder.Reset();

  GetContext()->mAmfEncoder.String("FCUnpublish");
  GetContext()->mAmfEncoder.Number(GetContext()->mTransactionId++);
  GetContext()->mAmfEncoder.Null();
  GetContext()->mAmfEncoder.String(GetContext()->mStreamName);

  RtmpMessageDetails details = RtmpMessageDetails(
    RTMP_CHANNEL_SYSTEM, 0, static_cast<uint32_t>(GetContext()->mAmfEncoder.GetBuffer().size()), RTMP_PKT_AMF0, 0);

  TTV_ErrorCode ret = SendChunkData(GetContext()->mAmfEncoder.GetBuffer(), details);
  ASSERT_ON_ERROR(ret);

  return ret;
}

TTV_ErrorCode ttv::broadcast::RtmpShutdownState::SendDeleteStreamMessage() {
  GetContext()->mAmfEncoder.Reset();

  GetContext()->mAmfEncoder.String("deleteStream");
  GetContext()->mAmfEncoder.Number(GetContext()->mTransactionId++);
  GetContext()->mAmfEncoder.Null();
  GetContext()->mAmfEncoder.Number(GetContext()->mStreamId);

  RtmpMessageDetails details(
    RTMP_CHANNEL_SYSTEM, 0, static_cast<uint32_t>(GetContext()->mAmfEncoder.GetBuffer().size()), RTMP_PKT_AMF0, 0);

  TTV_ErrorCode ret = SendChunkData(GetContext()->mAmfEncoder.GetBuffer(), details);
  ASSERT_ON_ERROR(ret);

  return ret;
}

void ttv::broadcast::RtmpShutdownState::OnEnterInternal() {
  TTV_ErrorCode ret = TTV_EC_SUCCESS;

  // TODO: There is probably data from the last packet in the buffer
  // we need to be able to drop that, but we it is hard because we
  // already told the rtmp server what size packet to expect. The problem
  // is that if we don't flush this and the connection speed is very slow
  // then the flush will take a long time to occur.

  ret = SendFCUnpublishMessage();
  if (TTV_FAILED(ret)) {
    GetContext()->SetNextState(RtmpContext::State::Error);
    GetContext()->mLastError = ret;
    return;
  }

  ret = SendDeleteStreamMessage();
  if (TTV_FAILED(ret)) {
    GetContext()->SetNextState(RtmpContext::State::Error);
    GetContext()->mLastError = ret;
    return;
  }

  ret = GetContext()->mSocket.FlushCache();
  if (TTV_FAILED(ret)) {
    GetContext()->SetNextState(RtmpContext::State::Error);
    GetContext()->mLastError = ret;
    return;
  }

  ret = GetContext()->mSocket.Disconnect();
  if (TTV_FAILED(ret)) {
    GetContext()->SetNextState(RtmpContext::State::Error);
    GetContext()->mLastError = ret;
    return;
  }

  GetContext()->SetNextState(RtmpContext::State::Idle);
}
