/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/passthroughaudiodevice.h"

#include "twitchsdk/broadcast/audioconstants.h"
#include "twitchsdk/broadcast/iaudiomixer.h"

namespace {
// const uint kMaxBufferDuration = 5;        // Seconds worth of audio samples
// const uint kMaxSamplesInBuffer = kMaxBufferDuration * ttv::broadcast::kAudioEncodeRate *
// ttv::broadcast::kNumAudioChannels;
}
//
//
// ttv::broadcast::PassthroughAudioDevice::PassthroughAudioDevice()
//: mWritePos(0)
//, mReadPos(0)
//, mSampleTime(0)
//, mSamplesBuffer(kMaxSamplesInBuffer)
//{
//}
//
//
// TTV_ErrorCode ttv::broadcast::PassthroughAudioDevice::Initialize()
//{
//  // NOP
//  return TTV_EC_SUCCESS;
//}
//
//
// TTV_ErrorCode ttv::broadcast::PassthroughAudioDevice::Shutdown()
//{
//  // NOP
//  return TTV_EC_SUCCESS;
//}
//
//
// TTV_ErrorCode ttv::broadcast::PassthroughAudioDevice::Process(const std::shared_ptr<IAudioMixer>& mixer, uint64_t&
// lastSampleTime)
//{
//  TTV_ASSERT(lastSampleTime);
//
//  // Store local copies of these so that if they change in the other thread
//  // submitting samples, our algorithm here will be unaffected
//  uint32_t readPos = mReadPos;
//  uint32_t writePos = mWritePos;
//
//  TTV_ErrorCode ret = TTV_EC_SUCCESS;
//
//  if (readPos > writePos)
//  {
//      TTV_ASSERT((kMaxSamplesInBuffer - readPos) % kAudioChannels == 0);
//      uint samplesPerChannel = (kMaxSamplesInBuffer - readPos) / kAudioChannels;
//      ret = mixer->SubmitAudioSamples(mAudioLayer, &mSamplesBuffer[readPos], samplesPerChannel, mSampleTime);
//      if (TTV_SUCCEEDED(ret))
//      {
//          readPos = 0;
//          mSampleTime += samplesPerChannel;
//      }
//  }
//  if (TTV_SUCCEEDED(ret) && writePos > readPos)
//  {
//      TTV_ASSERT((writePos - readPos) % kAudioChannels == 0);
//      uint samplesPerChannel = (writePos - readPos) / kAudioChannels;
//      ret = mixer->SubmitAudioSamples(mAudioLayer, &mSamplesBuffer[readPos], samplesPerChannel, mSampleTime);
//      readPos = writePos;
//      mSampleTime += samplesPerChannel;
//  }
//  mReadPos = readPos;
//
//  lastSampleTime = mSampleTime;
//
//  return ret;
//}
//
//
// TTV_ErrorCode ttv::broadcast::PassthroughAudioDevice::SubmitAudioSamples(const int16_t* samplesBuffer, uint
// numSamples)
//{
//  TTV_ErrorCode ret = TTV_EC_SUCCESS;
//
//  // Store local copies of these so that if they change in the other thread
//  // reading samples, our algorithm here will be unaffected
//  uint32_t readPos = mReadPos;
//  uint32_t writePos = mWritePos;
//
//  uint availableSpace = 0;
//  if (writePos > readPos)
//  {
//      availableSpace = (kMaxSamplesInBuffer - writePos) + readPos;
//  }
//  else
//  {
//      availableSpace = readPos - writePos;
//  }
//  --availableSpace;       // Guards against the case of trying to write the entire buffer size (where writePos would
//  end up at the same spot)
//
//  if (availableSpace < numSamples)
//  {
//      ret = TTV_EC_BROADCAST_AUDIO_BUFFER_TOO_BIG;
//  }
//  else
//  {
//      uint samplesToBufferEnd = std::min(numSamples, kMaxSamplesInBuffer-writePos);
//      memcpy(&mSamplesBuffer[writePos], samplesBuffer, samplesToBufferEnd*sizeof(int16_t));
//      if (samplesToBufferEnd < numSamples)
//      {
//          uint remainingSamples = numSamples - samplesToBufferEnd;
//          memcpy(&mSamplesBuffer[0], &samplesBuffer[samplesToBufferEnd], remainingSamples*sizeof(int16_t));
//      }
//      writePos = (writePos + numSamples) % kMaxSamplesInBuffer;
//  }
//
//  mWritePos = writePos;
//
//  return ret;
//}
