/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/pcmaudioframe.h"

#include "twitchsdk/broadcast/ipcmaudioframereceiver.h"

ttv::broadcast::PcmAudioFrame::PcmAudioFrame(const uint8_t* sampleBuffer, uint32_t numSamplesPerChannel,
  uint32_t numChannels, bool interleaved, AudioSampleFormat audioSampleFormat, uint64_t timeStamp)
    : AudioFrame(IPcmAudioFrameReceiver::GetReceiverTypeId()),
      mAudioSampleFormat(audioSampleFormat),
      mNumSamplesPerChannel(numSamplesPerChannel),
      mInterleaved(interleaved) {
  SetAudioFormat(AudioFormat::PCM);
  SetSampleRateHz(static_cast<uint32_t>(AudioSampleRate::Hz44100));
  SetNumChannels(numChannels);
  SetTimeStamp(timeStamp);

  size_t numBytesPerSample = 0;

  switch (audioSampleFormat) {
    case AudioSampleFormat::TTV_ASF_PCM_S16:
      numBytesPerSample = sizeof(int16_t);
      break;

    // TODO: We don't handle any other format yet
    default:
      TTV_ASSERT(false);
  }

  size_t numBytes = numBytesPerSample * numSamplesPerChannel * numChannels;

  mSampleBuffer.resize(numBytes);
  memcpy(&mSampleBuffer[0], sampleBuffer, numBytes);
}

ttv::broadcast::PcmAudioReceiver::PcmAudioReceiver(uint32_t numPcmSamplesPerFrame)
    : mNumPcmSamplesPerFrame(numPcmSamplesPerFrame) {}

TTV_ErrorCode ttv::broadcast::PcmAudioReceiver::GetNumPcmSamplesPerFrame(uint32_t& result) const {
  result = mNumPcmSamplesPerFrame;

  return TTV_EC_SUCCESS;
}

TTV_ErrorCode ttv::broadcast::PcmAudioReceiver::PackageFrame(const uint8_t* sampleBuffer, uint32_t numSamplesPerChannel,
  uint32_t numChannels, bool interleaved, AudioSampleFormat audioSampleFormat, uint64_t timeStamp,
  std::shared_ptr<AudioFrame>& result) {
  result = std::make_shared<PcmAudioFrame>(
    sampleBuffer, numSamplesPerChannel, numChannels, interleaved, audioSampleFormat, timeStamp);

  return TTV_EC_SUCCESS;
}
