/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/broadcast/internal/pch.h"

#include "twitchsdk/broadcast/internal/streamstats.h"

void ttv::broadcast::StreamStats::AddListener(const std::shared_ptr<IListener>& listener) {
  mListeners.AddListener(listener);
}

void ttv::broadcast::StreamStats::RemoveListener(const std::shared_ptr<IListener>& listener) {
  mListeners.RemoveListener(listener);
}

void ttv::broadcast::StreamStats::Add(StatType type, uint64_t data) {
  if (!mListeners.Empty()) {
    mQueue.push(value_t(type, data));
  }
}

void ttv::broadcast::StreamStats::Flush() {
  value_t entry;

  while (mQueue.try_pop(entry)) {
    mListeners.Invoke([this, &entry](const std::shared_ptr<IListener>& listener) {
      listener->OnStatReceived(this, entry.first, entry.second);
    });
  }
}
